# Generating URLs

Retrieving the application's base URL:

```php
$url = URL::base();
```

Generating a URL relative to the base URL:

```php
$url = URL::to('user/show');
```
Generating a HTTPS URL:

```php
$url = URL::asHttps('user/login');
```

Retrieving the current URL:

```php
$url = URL::current();
```

Retrieving the current URL including query string:

```php
$url = URL::full();
```

## URLs To Routes

Generating a URL to a named route:

```php
$url = URL::toRoute('user/show');
```
Sometimes you may need to generate a URL to a named route, but also need to specify the values that
should be used instead of the route's URI wildcards. It's easy to replace the wildcards with proper values:

Generating a URL to a named route with wildcard values:

```php
$url = URL::compute('user/profile', array($username));
```

## URLs To Controller Actions

Generating a URL to a controller action:

```php
$url = URL::compute('user/show');
```

Generating a URL to an action with wildcard values:

```php
$url = URL::compute('user/show', array($username));
```

## URLs To Assets

Generating a URL to an asset:

```php
$url = URL::toAsset('js/jquery.js');
```

## URL Helpers

There are several global functions for generating URLs designed to make your life easier and your code cleaner:

Generating a URL relative to the base URL:

```php
$url = Pimf\url('user/show');
```
